function G=indicator(raw,ncat)
% Produces an indicator matrix out of a vector of raw data
n=length(raw);
raw=reshape(raw,n,1);
if nargin==2
   ncat=max(ncat,max(raw));
else
   ncat=max(raw);
end
G=ones(n,1)*(1:ncat);
Raw=raw*ones(1,ncat);
G=G==Raw;
